using System;
using System.Runtime.InteropServices;
using System.Text;

namespace Sony
{
	namespace NP
	{
		public class Twitter
		{
			[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 0)]
			public struct PostTwitter
			{
				public string userText;				// Text to tweet.
				public string imagePath;			// Path for an image to attach.
				public bool forbidAttachPhoto;		// Forbidden attach photo by user.
				public bool disableEditTweetMsg;	// Disable initial tweet message string.
				public bool forbidOnlyImageTweet;	// Forbid tweet of only a image.
				public bool forbidNoImageTweet;		// Forbid tweet of no image.
				public bool disableChangeImage;		// Disable change initial attached image.
				public bool limitToScreenShot;		// limit to user's screen shot.
			};
			
			[DllImport("UnityNpToolkit")]
			private static extern bool PrxTwitterIsBusy();

			[DllImport("UnityNpToolkit")]
			private static extern bool PrxTwitterIsDialogOpen();

			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern ErrorCode PrxTwitterPostMessage(ref PostTwitter message);

			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern ErrorCode PrxTwitterCancelDialog();

			[DllImport("UnityNpToolkit")]
			private static extern bool PrxTwitterGetLastError(out ResultCode result);
			
			public static bool GetLastError(out ResultCode result)
			{
				PrxTwitterGetLastError(out result);
				return result.lastError == ErrorCode.NP_OK;
			}

			public static bool IsBusy()
			{
				return PrxTwitterIsBusy();
			}

			static public ErrorCode PostMessage(PostTwitter message)
			{
				return PrxTwitterPostMessage(ref message);
			}

			static public ErrorCode CancelDialog()
			{
				return PrxTwitterCancelDialog();
			}
			
			public static event Messages.EventHandler OnTwitterDialogStarted;
			public static event Messages.EventHandler OnTwitterDialogFinished;
			public static event Messages.EventHandler OnTwitterDialogCanceled;
			public static event Messages.EventHandler OnTwitterMessagePosted;
			public static event Messages.EventHandler OnTwitterMessagePostFailed;
			
			public static bool ProcessMessage(Messages.PluginMessage msg)
			{
				switch (msg.type)
				{
					case Messages.MessageType.kNPToolKit_TwitterDialogStarted:
						if (OnTwitterDialogStarted != null) OnTwitterDialogStarted(msg);
						return true;
					case Messages.MessageType.kNPToolKit_TwitterDialogFinished:
						if (OnTwitterDialogFinished != null) OnTwitterDialogFinished(msg);
						return true;
					case Messages.MessageType.kNPToolKit_TwitterDialogCanceled:
						if (OnTwitterDialogCanceled != null) OnTwitterDialogCanceled(msg);
						return true;
					case Messages.MessageType.kNPToolKit_TwitterMessagePosted:
						if (OnTwitterMessagePosted != null) OnTwitterMessagePosted(msg);
						return true;
					case Messages.MessageType.kNPToolKit_TwitterMessagePostFailed:
						if (OnTwitterMessagePostFailed != null) OnTwitterMessagePostFailed(msg);
						return true;
				}
				
				return false;
			}
		}
	}
}
